; Questo programma serve a "spegnere" il processore.
; Lo mette in modalita' basso consumo.
;
; Utilizzo i nomi standard per i registri mappati in memoria
	.mmregs
;
; Qui dichiaro tutte le variabili necessarie
;
	.ds     0f00h           ; Inizio della memoria dei dati
TA      .word   17              ; TA AIC value - Fcut = 8 KHz
RA      .word   17              ; RA AIC value - Fcut = 8 KHz
TB      .word   37              ; TB AIC value - Fs = 2*Fcut
RB      .word   37              ; RB AIC value - Fs = 2*Fcut
AIC_CTR .word   28h              ; |LP xx G1 G0 | SY AX LB BP|
				; +------------+------------+
				;  |     GAIN    |  |  |  +-- BP Filter
				;  |     Synch --+  |  +----- Loopback
				;  |     Auxin -----+
				;  + (sinx)/x filter
;
;
	.ps     080ah           ; Imposto il vettore delle interruzioni
; Salta a RX quando avviene un interrupt in ricezione
RINT    b       RX
;
; Salta a TX quando avviene un interrupt in trasmissione
XINT    b       TX              ; Branch to TX on transmit interrupt
;
	.ps 0a00h               ; Scrivo nella memoria di programma
	.entry                  ; Punto di inizio del programma
	.text                   ; Sezione codice
;
; Inizializzazione del processore, che viene fatta una sola volta
; all'atto della partenza del programma
START   setc    INTM            ; Disable interrupts
	ldp     #0              ; Set data page pointer to page zero
	splk    #0834h,PMST     ; Write 16 bit pattern to PMST register
	lacc    #0              ; Load accumulator with number zero
	;-----------------------;
	samm    CWSR            ; Set software wait state to zero
	samm    PDWSR           ; Set software wait state to zero
	splk    #022h,IMR       ; Using XINT syn TX & RX
	call    AIC             ; Initialize AIC and enable interrupts
	;-----------------------;
	clrc    OVM             ; Overflow mode is set to zero
	spm     0               ; Product shift mode is set to zero
; Cosi' maschero gli interrupts sia di ricezione che di trasmissione
	splk    #02h,IMR
	clrc    INTM            ; Enable interrupts
;
; La parte seguente e' un ciclo infinito da cui il processore NON esce
WAIT    idle2                   ; Spengo tutto quello che posso
	nop                     ; nessuna operazione
	nop                     ; nessuna operazione
	b       WAIT            ; Torno all'inizio
;
; Questa e' la routine che viene eseguita quando avviene un interrupt
; di ricezione. Non esegue niente.
RX     rete                    ; ritorna dall'interruzione
;
; Questa e' la routine che viene eseguita quando avviene un interrupt
; di trasmissione. Non esegue niente.
TX      rete                    ; ritorna dall'interruzione
;
; Le seguenti routines servono ad inizializzare l'AIC
; con i valori voluti.
AIC     splk    #20h,TCR        ; To generate 10 MHz from Tout
	splk    #01h,PRD        ; Load period counter with 1
	mar     *,AR0           ; Modify AR pointer (used with GREG)
	lacc    #0008h          ; Load acc with 08h
	sacl    SPC             ; Store acc in SPC
	lacc    #00C8h          ; Load acc with 0C8h
	sacl    SPC             ; Set and reset SPC register
	;-----------------------;
	lacc    #080h           ; Initialise 8000h to FFFFh as global memory
	sach    DXR             ; Store high acc to DXR
	sacl    GREG            ; Store to global memory register
	lar     AR0,#0FFFFh     ; Set AR0 register
	rpt     #10000          ; Set repeat counter
	lacc    *,0,AR0         ; Access global memory
	sach    GREG            ; Disable global memory
	;-----------------------;
	ldp     #TA             ; Load data page TA
	setc    SXM             ; Set SXM for sign extension mode
	lacc    TA,9            ; Load accumulator with TA data
	add     RA,2            ; Load accumulator with RA  data
	call    AIC2ND          ; Call function AIC2ND
	;-----------------------;
	ldp     #TB             ; Load data page TB
	lacc    TB,9            ; Load accumulator with TB data
	add     RB,2            ; Load accumulator with RB data
	add     #02h            ; Add 10b to set status bits
	call    AIC2ND          ; Call function AIC2ND
	;-----------------------;
	ldp     #AIC_CTR        ; Load data page AIC_CTR
	lacc    AIC_CTR,2       ; Initialized control register
	add     #03h            ; Add 11b to set status bits
	call    AIC2ND          ; Call function AIC2ND
	ret                     ; Return from call
;-------------------------------;
AIC2ND  ldp     #0              ; Load data page zero
	sach    DXR             ; Store upper acc to DXR
	clrc    INTM            ; Enable interrupts
	idle                    ; Idle until interrupt - TINT
	add     #6h,15          ; Set 2 LSBs of upper acc high
	sach    DXR             ; Store upper acc to DXR
	idle                    ; Idle until interrupt - TINT
	sacl    DXR             ; Store lower acc to DXR
	idle                    ; Idle until interrupt - TINT
	lacl    #0              ; Store lower acc to DXR - flushing
	sacl    DXR             ; make sure the word got sent
	idle                    ; Idle until interrupt - TINT
	setc    INTM            ; Disable interrupts
	ret                     ; Return from call
;-------------------------------;
	.end                    ; End of program
